//
//  GlyphsToolbarExtensionProtocol.h
//  GlyphsCore
//
//  Created by Florian Pircher on 25.05.23.
//  Copyright © 2023 schriftgestaltung.de. All rights reserved.
//

#ifndef GlyphsToolbarExtensionProtocol_h
#define GlyphsToolbarExtensionProtocol_h

NS_ASSUME_NONNULL_BEGIN

@protocol GlyphsToolbarExtension

/// Returns the array of identifier strings for the allowed toolbar items.
- (NSArray<NSToolbarItemIdentifier> *)toolbarAllowedItemIdentifiers:(NSToolbar *)toolbar proposedItemIdentifiers:(NSArray<NSToolbarItemIdentifier> *)proposedItemIdentifiers;

/// Returns the toolbar item for the specified identifier.
- (nullable NSToolbarItem *)toolbar:(NSToolbar *)toolbar itemForItemIdentifier:(NSToolbarItemIdentifier)itemIdentifier willBeInsertedIntoToolbar:(BOOL)flag;

@optional

/// Returns the array of identifier strings for the default toolbar items.
- (NSArray<NSToolbarItemIdentifier> *)toolbarDefaultItemIdentifiers:(NSToolbar *)toolbar proposedItemIdentifiers:(NSArray<NSToolbarItemIdentifier> *)proposedItemIdentifiers;

/// Called after the toolbar has been added to the window.
- (void)windowDidLoad:(NSWindow *)window;

- (void)windowWillClose:(NSWindow *)window;

@end

@protocol GlyphsToolbarExtensionProvider

/// Called before the toolbar is added to the window.
- (nullable NSObject<GlyphsToolbarExtension> *)toolbarExtensionForWindow:(NSWindow *)window;

@end

NS_ASSUME_NONNULL_END

#endif /* GlyphsToolbarExtensionProtocol_h */
